# Authentication Setup Guide

## Environment Variables

Create a `.env` file in the root directory with the following content:

```
VITE_AUTH_EMAIL=mortadaalseid7@gmail.com
VITE_AUTH_PASSWORD=SLAH123slah@@
```

**Important:** 
- The `.env` file should be added to `.gitignore` to keep credentials secure
- Never commit the `.env` file to version control

## How It Works

1. **Login Modal**: Clicking "Log in" in the navbar opens a modal with email and password fields
2. **Authentication**: Credentials are compared against values in `.env` file
3. **Session Storage**: On successful login, a secure cookie is set (7 days expiration)
4. **Protected Route**: The `/dashboard` route is protected and redirects to home if not authenticated
5. **Logout**: Users can logout from the dashboard header

## Features

- ✅ Clean, minimal login modal matching design system
- ✅ Secure cookie-based authentication
- ✅ Protected dashboard route
- ✅ Automatic redirect to home if not authenticated
- ✅ Single user authentication (credentials from .env)
- ✅ No external authentication services
- ✅ Production-ready implementation

## Testing

1. Start the dev server: `npm run dev`
2. Click "Log in" in the navbar
3. Enter credentials from `.env` file
4. You'll be redirected to `/dashboard` on success
5. Try accessing `/dashboard` directly without logging in - you'll be redirected to home

