import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import { HelmetProvider } from 'react-helmet-async';
import { AuthProvider } from './contexts/AuthContext';
import HomePage from './components/HomePage';
import SolutionsPage from './components/SolutionsPage';
import PricingPage from './components/PricingPage';
import AboutPage from './components/AboutPage';
import DashboardPage from './components/DashboardPage';
import ProtectedRoute from './components/ProtectedRoute';

function App() {
    return (
        <HelmetProvider>
            <AuthProvider>
                <Router>
                    <div className="min-h-screen bg-dark text-white selection:bg-primary selection:text-white">
                        <Routes>
                            <Route path="/" element={<HomePage />} />
                            <Route path="/solutions" element={<SolutionsPage />} />
                            <Route path="/pricing" element={<PricingPage />} />
                            <Route path="/about" element={<AboutPage />} />
                            <Route
                                path="/dashboard"
                                element={
                                    <ProtectedRoute>
                                        <DashboardPage />
                                    </ProtectedRoute>
                                }
                            />
                        </Routes>
                    </div>
                </Router>
            </AuthProvider>
        </HelmetProvider>
    )
}

export default App
