import React from 'react';

interface LiveToggleProps {
    isLive: boolean;
    onToggle: () => void;
}

const LiveToggle: React.FC<LiveToggleProps> = ({ isLive, onToggle }) => {
    return (
        <div className="absolute top-6 left-6 bg-white/90 backdrop-blur shadow-sm border border-gray-200 rounded-lg p-1 flex items-center gap-1 z-30">
            <button
                onClick={isLive ? undefined : onToggle}
                className={`px-3 py-1.5 rounded-md text-sm font-medium transition flex items-center gap-2 ${isLive ? 'bg-red-50 text-red-600 shadow-sm' : 'text-gray-500 hover:bg-gray-50'
                    }`}
            >
                <span className={`w-2 h-2 rounded-full ${isLive ? 'bg-red-500 animate-pulse' : 'bg-gray-400'}`}></span>
                LIVE
            </button>
            <button
                onClick={!isLive ? undefined : onToggle}
                className={`px-3 py-1.5 rounded-md text-sm font-medium transition flex items-center gap-2 ${!isLive ? 'bg-blue-50 text-blue-600 shadow-sm' : 'text-gray-500 hover:bg-gray-50'
                    }`}
            >
                <i className="fa-solid fa-clock-rotate-left"></i>
                PLAYBACK
            </button>
        </div>
    );
};

export default LiveToggle;
