import React from 'react';

interface TimelineBarProps {
    isPlaying: boolean;
    speed: number;
    onPlayPause: () => void;
    onSpeedChange: (speed: number) => void;
}

const TimelineBar: React.FC<TimelineBarProps> = ({ isPlaying, speed, onPlayPause, onSpeedChange }) => {
    return (
        <div className="absolute bottom-6 left-1/2 transform -translate-x-1/2 bg-white/90 backdrop-blur shadow-lg border border-gray-200 rounded-full px-6 py-3 flex items-center gap-6 z-30">
            {/* Play/Pause */}
            <button
                onClick={onPlayPause}
                className="w-10 h-10 rounded-full bg-primary text-white flex items-center justify-center hover:bg-emerald-700 transition shadow-md"
                aria-label={isPlaying ? 'Pause Simulation' : 'Play Simulation'}
            >
                <i className={`fa-solid ${isPlaying ? 'fa-pause' : 'fa-play'}`}></i>
            </button>

            {/* Progress Bar (Visual Only) */}
            <div className="flex flex-col w-64">
                <div className="flex justify-between text-xs text-gray-500 mb-1">
                    <span>00:00</span>
                    <span>12:00</span>
                    <span>23:59</span>
                </div>
                <div className="w-full bg-gray-200 rounded-full h-1.5 overflow-hidden">
                    <div className="bg-primary h-full rounded-full animate-progress" style={{ width: '45%' }}></div>
                </div>
            </div>

            {/* Speed Control */}
            <div className="flex items-center gap-2 border-l border-gray-300 pl-4">
                <span className="text-xs font-semibold text-gray-500">SPEED</span>
                <div className="flex bg-gray-100 rounded-lg p-1">
                    {[1, 2, 5].map((s) => (
                        <button
                            key={s}
                            onClick={() => onSpeedChange(s)}
                            className={`px-2 py-0.5 text-xs rounded transition ${speed === s ? 'bg-white shadow text-primary font-bold' : 'text-gray-500 hover:text-gray-700'
                                }`}
                        >
                            {s}x
                        </button>
                    ))}
                </div>
            </div>
        </div>
    );
};

export default TimelineBar;
