import { motion } from 'framer-motion';
import { ArrowRight, Activity, Shield, Leaf, BarChart3 } from 'lucide-react';

export default function Hero() {
    return (
        <section className="relative min-h-screen flex items-center pt-20 overflow-hidden">
            {/* Background Elements */}
            <div className="absolute inset-0 bg-dark z-0">
                <div className="absolute top-0 left-1/4 w-96 h-96 bg-primary/20 rounded-full blur-[128px] animate-pulse-slow" />
                <div className="absolute bottom-0 right-1/4 w-96 h-96 bg-secondary/30 rounded-full blur-[128px] animate-pulse-slow delay-1000" />
            </div>

            <div className="container mx-auto px-6 relative z-10 grid lg:grid-cols-2 gap-12 items-center">
                {/* Text Content */}
                <motion.div
                    initial={{ opacity: 0, x: -50 }}
                    animate={{ opacity: 1, x: 0 }}
                    transition={{ duration: 0.8 }}
                >
                    <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/5 border border-white/10 mb-8">
                        <span className="w-2 h-2 rounded-full bg-primary animate-pulse" />
                        <span className="text-sm text-gray-300">Unified Compliance Platform</span>
                    </div>

                    <h1 className="text-5xl lg:text-7xl font-bold leading-tight mb-6">
                        Unified Saudi Platform for <span className="text-gradient">Compliance</span> & Sustainability
                    </h1>

                    <p className="text-xl text-gray-400 mb-8 leading-relaxed max-w-xl">
                        The platform that brings together everything industrial facilities and enterprises need in one place: carbon & emissions, quality (ISO), environmental compliance, occupational safety, and government reporting — all automated at scale.
                    </p>

                    <div className="flex flex-wrap gap-4">
                        <motion.button
                            whileHover={{ scale: 1.05 }}
                            whileTap={{ scale: 0.95 }}
                            className="bg-primary hover:bg-primary/90 text-white px-8 py-4 rounded-2xl font-semibold text-lg transition-all shadow-lg shadow-primary/25 flex items-center gap-2"
                        >
                            Request Free Demo
                            <ArrowRight className="w-5 h-5" />
                        </motion.button>

                        <motion.button
                            whileHover={{ scale: 1.05 }}
                            whileTap={{ scale: 0.95 }}
                            className="bg-white/5 hover:bg-white/10 text-white px-8 py-4 rounded-2xl font-semibold text-lg transition-all border border-white/10 backdrop-blur-sm"
                        >
                            Watch Video
                        </motion.button>
                    </div>
                </motion.div>

                {/* 3D Dashboard Visualization */}
                <motion.div
                    initial={{ opacity: 0, scale: 0.8, rotateX: 20 }}
                    animate={{ opacity: 1, scale: 1, rotateX: 0 }}
                    transition={{ duration: 1, delay: 0.2 }}
                    className="relative perspective-1000"
                >
                    <div className="relative z-10 bg-dark/80 backdrop-blur-xl border border-white/10 rounded-3xl p-6 shadow-2xl transform rotate-y-12 hover:rotate-y-0 transition-transform duration-500">
                        {/* Dashboard Header */}
                        <div className="flex items-center justify-between mb-8 border-b border-white/10 pb-4">
                            <div className="flex gap-2">
                                <div className="w-3 h-3 rounded-full bg-red-500" />
                                <div className="w-3 h-3 rounded-full bg-yellow-500" />
                                <div className="w-3 h-3 rounded-full bg-green-500" />
                            </div>
                            <div className="text-sm text-gray-400">Mutqin Pro Dashboard</div>
                        </div>

                        {/* Dashboard Content Grid */}
                        <div className="grid grid-cols-2 gap-4">
                            <div className="bg-white/5 p-4 rounded-2xl border border-white/5">
                                <div className="flex items-center gap-3 mb-2">
                                    <div className="p-2 bg-primary/20 rounded-lg text-primary">
                                        <Leaf className="w-5 h-5" />
                                    </div>
                                    <span className="text-gray-400 text-sm">Carbon Footprint</span>
                                </div>
                                <div className="text-2xl font-bold">2,450 <span className="text-xs text-gray-500 font-normal">tCO2e</span></div>
                                <div className="text-xs text-green-400 mt-1">↓ 12% vs last month</div>
                            </div>

                            <div className="bg-white/5 p-4 rounded-2xl border border-white/5">
                                <div className="flex items-center gap-3 mb-2">
                                    <div className="p-2 bg-blue-500/20 rounded-lg text-blue-500">
                                        <Shield className="w-5 h-5" />
                                    </div>
                                    <span className="text-gray-400 text-sm">Compliance Score</span>
                                </div>
                                <div className="text-2xl font-bold">98.5%</div>
                                <div className="text-xs text-green-400 mt-1">All systems operational</div>
                            </div>

                            <div className="bg-white/5 p-4 rounded-2xl border border-white/5 col-span-2">
                                <div className="flex items-center gap-3 mb-4">
                                    <div className="p-2 bg-purple-500/20 rounded-lg text-purple-500">
                                        <Activity className="w-5 h-5" />
                                    </div>
                                    <span className="text-gray-400 text-sm">Real-time Emissions</span>
                                </div>
                                <div className="h-24 flex items-end gap-2">
                                    {[40, 65, 45, 80, 55, 70, 45, 60, 75, 50].map((h, i) => (
                                        <div
                                            key={i}
                                            className="flex-1 bg-gradient-to-t from-primary/20 to-primary rounded-t-sm transition-all duration-500 hover:opacity-80"
                                            style={{ height: `${h}%` }}
                                        />
                                    ))}
                                </div>
                            </div>
                        </div>

                        {/* Floating Elements */}
                        <motion.div
                            animate={{ y: [0, -10, 0] }}
                            transition={{ duration: 4, repeat: Infinity, ease: "easeInOut" }}
                            className="absolute -right-8 -top-8 bg-dark/90 backdrop-blur-md p-4 rounded-2xl border border-white/10 shadow-xl"
                        >
                            <div className="flex items-center gap-3">
                                <div className="w-10 h-10 rounded-full bg-green-500/20 flex items-center justify-center text-green-500">
                                    <BarChart3 className="w-5 h-5" />
                                </div>
                                <div>
                                    <div className="text-xs text-gray-400">ISO 14001</div>
                                    <div className="text-sm font-bold text-green-400">Certified</div>
                                </div>
                            </div>
                        </motion.div>
                    </div>
                </motion.div>
            </div>
        </section>
    );
}
