import { FloorGrid } from './FloorGrid';
import { useInputConfig } from '../store';

export function FloorGridCanvas() {
  const { buildingConfig } = useInputConfig();

  return (
    <div className="flex-1 overflow-y-auto p-6">
      <div className="mb-6">
        <p className="text-sm text-gray-600">
          Drag components into floor grid cells to configure the Carbon Center input pipeline.
        </p>
      </div>
      <div className="space-y-8">
        {buildingConfig.floors.map((floor) => (
          <FloorGrid key={floor.id} floor={floor} />
        ))}
      </div>
    </div>
  );
}

