import { X } from 'lucide-react';
import { motion, AnimatePresence } from 'framer-motion';
import { useInputConfig } from '../store';
import { DndProvider } from '../dnd/DndContext';
import { ComponentsLibrary } from './ComponentsLibrary';
import { FloorGridCanvas } from './FloorGridCanvas';
import { ModuleDetailsPanel } from './ModuleDetailsPanel';
import { Database } from 'lucide-react';

export function InputConfigDrawer() {
  const { isDrawerOpen, closeDrawer } = useInputConfig();

  return (
    <AnimatePresence>
      {isDrawerOpen && (
        <>
          {/* Overlay */}
          <motion.div
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            exit={{ opacity: 0 }}
            onClick={closeDrawer}
            className="fixed inset-0 bg-black/50 backdrop-blur-sm z-50"
          />
          
          {/* Drawer */}
          <motion.div
            initial={{ x: '100%' }}
            animate={{ x: 0 }}
            exit={{ x: '100%' }}
            transition={{ type: 'spring', damping: 30, stiffness: 300 }}
            className="fixed right-0 top-0 h-full w-full max-w-7xl bg-white shadow-2xl z-50 flex flex-col"
          >
            {/* Header */}
            <div className="h-16 border-b border-gray-200 flex items-center justify-between px-6 bg-gradient-to-r from-gray-50 to-white">
              <div className="flex items-center gap-3">
                <div className="p-2 bg-primary/10 rounded-lg">
                  <Database className="w-5 h-5 text-primary" />
                </div>
                <div>
                  <h2 className="text-lg font-semibold text-gray-800">Input Configuration</h2>
                  <p className="text-xs text-gray-500">Configure Carbon Center input pipeline</p>
                </div>
              </div>
              <button
                onClick={closeDrawer}
                className="p-2 hover:bg-gray-100 rounded-lg transition"
              >
                <X className="w-5 h-5 text-gray-500" />
              </button>
            </div>

            {/* Content */}
            <DndProvider
              dragOverlay={
                <div className="p-4 bg-white border-2 border-primary rounded-lg shadow-lg">
                  <p className="text-sm font-medium text-gray-800">Dragging component...</p>
                </div>
              }
            >
              <div className="flex-1 flex overflow-hidden">
                <ComponentsLibrary />
                <FloorGridCanvas />
                <ModuleDetailsPanel />
              </div>
            </DndProvider>
          </motion.div>
        </>
      )}
    </AnimatePresence>
  );
}

