import { useDraggable, useDroppable } from '@dnd-kit/core';
import { CSS } from '@dnd-kit/utilities';
import { ModuleType, GridPosition } from '../types';

export function useComponentDraggable(id: string, type: ModuleType) {
  const { attributes, listeners, setNodeRef, transform, isDragging } = useDraggable({
    id,
    data: {
      type,
    },
  });

  const style = {
    transform: CSS.Translate.toString(transform),
    opacity: isDragging ? 0.5 : 1,
  };

  return {
    ref: setNodeRef,
    style,
    attributes,
    listeners,
    isDragging,
  };
}

export function useGridCellDroppable(
  id: string,
  floorId: string,
  position: GridPosition
) {
  const { setNodeRef, isOver } = useDroppable({
    id: id,
    data: {
      floorId,
      position,
    },
  });

  return {
    ref: setNodeRef,
    isOver,
  };
}

