import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import { resolve } from 'path'

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [react()],
  build: {
    rollupOptions: {
      input: {
        main: resolve(__dirname, 'index.html'),
        inputConfig: resolve(__dirname, 'src/pages/input-configuration/index.tsx'),
      },
      output: {
        entryFileNames: (chunkInfo) => {
          return chunkInfo.name === 'inputConfig' 
            ? 'input-configuration.js' 
            : 'assets/[name]-[hash].js';
        },
        format: 'iife',
        name: 'InputConfiguration',
        globals: {
          'react': 'React',
          'react-dom/client': 'ReactDOM',
        },
      },
      external: ['react', 'react-dom', 'react-dom/client'],
    },
  },
})
