import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import { resolve } from 'path'

// Vite config specifically for building the Input Configuration component
export default defineConfig({
  plugins: [react()],
  build: {
    rollupOptions: {
      input: resolve(__dirname, 'src/pages/input-configuration/standalone.tsx'),
      output: {
        format: 'iife',
        name: 'InputConfiguration',
        dir: 'dist',
        entryFileNames: 'input-configuration.js',
        globals: {
          'react': 'React',
          'react-dom': 'ReactDOM',
        },
        inlineDynamicImports: true,
      },
      external: (id) => {
        // Only externalize React and ReactDOM (loaded from CDN)
        // All other dependencies including relative imports should be bundled
        return id === 'react' || id === 'react-dom' || id === 'react-dom/client' || id.startsWith('react/jsx');
      },
    },
    outDir: 'dist',
    emptyOutDir: false,
  },
  resolve: {
    alias: {
      '@': resolve(__dirname, './src'),
    },
    preserveSymlinks: false,
  },
})

